//
//  ViewController.swift
//  Slider
//
//  Created by 9Brainz on 29/11/18.
//  Copyright © 2018 9Brainz. All rights reserved.
//

import UIKit

class ViewController: UIViewController
{

    @IBOutlet weak var lblCustomSliderValue: UILabel!
    @IBOutlet weak var customSlider: CustomSlider!
    
    @IBOutlet weak var lblSliderValue: UILabel!
    @IBOutlet weak var slider: UISlider!
    override func viewDidLoad()
    {
        super.viewDidLoad()
        
        lblCustomSliderValue.text = "\(Int(customSlider.value))"

        lblSliderValue.text = "\(Int(slider.value))"
        slider.minimumTrackTintColor = .green
        slider.maximumTrackTintColor = .red
        slider.thumbTintColor = .black
        
    }
    @IBAction func SliderTap(_ sender: UISlider)
    {
        let value = sender.value
        lblSliderValue.text = "\(Int(value))"
    }
    
    @IBAction func customSliderTap(_ sender: UISlider)
    {
        let value = sender.value
        lblCustomSliderValue.text = "\(Int(value))"
    }
    override func viewDidLayoutSubviews()
    { 
        self.customSlider.setMinimumTrackImage(UIImage(named: "slider-active"), for: .normal)
        self.customSlider.setMaximumTrackImage(UIImage(named: "slider"), for: .normal)
        self.customSlider.setThumbImage(UIImage(named: "knob"), for: .normal)

    }
    
    
}

